// dispimpl2.h: IDispatchImpl2
/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1998 Chris Sells
// Wszystkie prawa zastrzeona.
//
// 10/25/98:
// -Pierwsza wersja.
//
// UYCIE NA WASNE RYZYKO.
//
// Z autorem mona skontaktowa si pod adresem csells@sellsbrothers.com.
/////////////////////////////////////////////////////////////////////////////
// Ten nagwek definiuje trzy klasy C++ uywane do implementacji
// interfejsw:
//  -IDualDispImpl do implementacji podwjnych interfejsw.
//  -IDelegatingDispImpl do implementacji delegujcych interfejsw.
//  -IRawDispImpl do implementacji pierwotnych interfejsw.
/////////////////////////////////////////////////////////////////////////////
// IDualDispImpl: Wykorzystywany wraz z interfejsami zadeklarowanymi w poniszy sposb:
//
// [dual]
// interface IFoo : IDispatch
// {
//    ...
// }
//
// IDualDispImpl implementuje wszystkie cztery metody IDispatch.
// IDualDispImpl uzyskuje wpisy vtbl IDispatch poprzez dziedziczenie
// z IDispatch, ktry suy jako klasa bazowa dla podwjnych interfejsw.
//
// Uycie:
//  class CFoo : ..., public IDualDispImpl<IFoo>
//
// Aktualny IDispatchImpl moe by wykorzystany tylko dla podwjnych interfejsw.
// UWAGA: Mona tu uy typedef, ale wol uzyska piid poprzez __uuidof.
/////////////////////////////////////////////////////////////////////////////
// IDelegatingDispImpl: Wykorzystywany wraz z interfejsami zadeklarowanymi w poniszy sposb:
//
// [oleautomation]
// interface IFoo : IUnknown
// {
//    ...
// }
//
// dispinterface DFoo
// {
//    interface IFoo; // Logiczna delegacja do innego interfejsu
// }
//
// IDelegatingDispImpl implementuje wszystkie cztery metody IDispatch.
// IDelegatingDispImpl uzyskuje wpisy vtbl IDispatch poprzez dziedziczenie
// z IDispatch w uzupenieniu interfejsu nie opartego na IDispatch.
//
// Uycie:
//  class CFoo : ..., public IDelegatingDispImpl<DFoo, IFoo>
/////////////////////////////////////////////////////////////////////////////
// IRawDispImpl: Wykorzystywany wraz z interfejsami zadeklarowanymi w poniszy sposb:
//
// dispinterface DFoo
// {
// properties:
//   ...
// methods:
//   ...
// }
//
// IRawDispImpl implementuje trzy metody IDispatch.
// Wywoanie jest zalene od uytkownika.
// IRawDispImpl uzyskuje wpisy vtbl IDispatch poprzez dziedziczenie
// z IDispatch w uzupenieniu interfejsu nie opartego na IDispatch.
//
// Uycie:
//  class CFoo : ..., public IRawDispImpl<DFoo>
//  {
//  ...
//      STDMETHODIMP Invoke(...);   // Implementowane rcznie.
//  };
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// IDualDispImpl

template <class T, const IID* piid = &__uuidof(T), const GUID* plibid = &CComModule::m_libid, WORD wMajor = 1,
          WORD wMinor = 0, class tihclass = CComTypeInfoHolder>
class ATL_NO_VTABLE IDualDispImpl : public IDispatchImpl<T, piid, plibid, wMajor, wMinor, tihclass> {};

/////////////////////////////////////////////////////////////////////////////
// IDelegatingDispImpl

template <class D, class T, const IID* piid = &__uuidof(T), const GUID* plibid = &CComModule::m_libid, WORD wMajor = 1,
          WORD wMinor = 0, class tihclass = CComTypeInfoHolder>
class ATL_NO_VTABLE IDelegatingDispImpl : public T, public D
{
public:
	typedef tihclass _tihclass;
// IDispatch
	STDMETHOD(GetTypeInfoCount)(UINT* pctinfo)
	{
		*pctinfo = 1;
		return S_OK;
	}
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo** pptinfo)
	{
		return _tih.GetTypeInfo(itinfo, lcid, pptinfo);
	}
	STDMETHOD(GetIDsOfNames)(REFIID riid, LPOLESTR* rgszNames, UINT cNames,
		LCID lcid, DISPID* rgdispid)
	{
		return _tih.GetIDsOfNames(riid, rgszNames, cNames, lcid, rgdispid);
	}
	STDMETHOD(Invoke)(DISPID dispidMember, REFIID riid,
		LCID lcid, WORD wFlags, DISPPARAMS* pdispparams, VARIANT* pvarResult,
		EXCEPINFO* pexcepinfo, UINT* puArgErr)
	{
        
		return _tih.Invoke(reinterpret_cast<IDispatch*>(static_cast<T*>(this)),
                           dispidMember, riid, lcid, wFlags, pdispparams,
                           pvarResult, pexcepinfo, puArgErr);
	}
protected:
	static _tihclass _tih;
	static HRESULT GetTI(LCID lcid, ITypeInfo** ppInfo)
	{
		return _tih.GetTI(lcid, ppInfo);
	}
};

template <class D, class T, const IID* piid, const GUID* plibid, WORD wMajor, WORD wMinor, class tihclass>
IDelegatingDispImpl<D, T, piid, plibid, wMajor, wMinor, tihclass>::_tihclass
    IDelegatingDispImpl<D, T, piid, plibid, wMajor, wMinor, tihclass>::_tih =
        {piid, plibid, wMajor, wMinor, NULL, 0, NULL, 0};

/////////////////////////////////////////////////////////////////////////////
// IRawDispImpl

template <class T, const IID* piid = &__uuidof(T), const GUID* plibid = &CComModule::m_libid, WORD wMajor = 1,
          WORD wMinor = 0, class tihclass = CComTypeInfoHolder>
class ATL_NO_VTABLE IRawDispImpl : public T
{
public:
	typedef tihclass _tihclass;
// IDispatch
	STDMETHOD(GetTypeInfoCount)(UINT* pctinfo)
	{
		*pctinfo = 1;
		return S_OK;
	}
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo** pptinfo)
	{
		return _tih.GetTypeInfo(itinfo, lcid, pptinfo);
	}
	STDMETHOD(GetIDsOfNames)(REFIID riid, LPOLESTR* rgszNames, UINT cNames,
		LCID lcid, DISPID* rgdispid)
	{
		return _tih.GetIDsOfNames(riid, rgszNames, cNames, lcid, rgdispid);
	}

    // Wywoanie powinno by zaimplementowane samodzielnie.
	STDMETHOD(Invoke)(DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pdispparams, VARIANT* pvarResult, EXCEPINFO* pexcepinfo, UINT* puArgErr) = 0;

protected:
	static _tihclass _tih;
	static HRESULT GetTI(LCID lcid, ITypeInfo** ppInfo)
	{
		return _tih.GetTI(lcid, ppInfo);
	}
};

template <class T, const IID* piid, const GUID* plibid, WORD wMajor, WORD wMinor, class tihclass>
IRawDispImpl<T, piid, plibid, wMajor, wMinor, tihclass>::_tihclass
    IRawDispImpl<T, piid, plibid, wMajor, wMinor, tihclass>::_tih =
        {piid, plibid, wMajor, wMinor, NULL, 0, NULL, 0};
